//
//  GLiveFastSDK.h
//  GLiveSDK
//
//  Created by net263 on 2021/8/11.
//

#import <Foundation/Foundation.h>
#import "GLiveFastConfig.h"
NS_ASSUME_NONNULL_BEGIN

typedef void(^joinError)(void);

@interface GLiveFastSDK : NSObject

@property (nonatomic, copy) joinError joinErrorBlock;

@property(nonatomic, strong)GLiveFastConfig *config;

+ (instancetype)sharedInstance;

-(void)joinWithGSConnectInfo:(GSConnectInfo*)connectInfo config:(GLiveFastConfig*)config;

/**
 设置退出回调
 @param completion 退出回调
 */
- (void)setLeaveCompletion:(void (^ __nullable)(void))completion;

/**
 设置加入回调
 */
-(void)setJoinCompletion:(void (^ __nullable)(int result))completion;
#pragma mark - private
/**
 登出 并清除部分资源 （用户不需要主动调用）
 */
- (void)logout;
@end

NS_ASSUME_NONNULL_END
